{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:11:58 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  Buttons,
  IniFiles,
  MMSystem,
  MMObj,
  MMUtils,
  MMSlider,
  MMHTimer,
  MMDSPMtr,
  MMWavOut,
  MMRingBf,
  MMConect,
  MMDSPObj,
  MMWavIn,
  MMDesign,
  MMLevel,
  MMLEDS,
  MMDIBCv,
  MMSpectr,
  MMVolume,
  MMWheel,
  MMEdit,
  MMFlange,
  MMHook;

type
  TMainForm = class(TForm)
    MMDesigner1: TMMDesigner;
    MMWaveIn: TMMWaveIn;
    MMConnector1: TMMConnector;
    MMRingBuffer1: TMMRingBuffer;
    MMWaveOut1: TMMWaveOut;
    DSPMeter: TMMDSPMeter;
    MMHiTimer1: TMMHiTimer;
    MasterVolume: TMMVolume;
    Spectrum2: TMMSpectrum;
    Flanger: TMMFlanger;
    Panel8: TPanel;
    Label4: TLabel;
    DSPLabel: TLabel;
    Label25: TLabel;
    LEDOver: TMMLED;
    Label7: TLabel;
    StartBtn: TButton;
    StopBtn: TButton;
    VolumeMaster: TMMWheel;
    Panel7: TPanel;
    Bevel1: TBevel;
    lblInputGain: TLabel;
    Bevel2: TBevel;
    Label1: TLabel;
    lblWetMix: TLabel;
    Bevel3: TBevel;
    lblFeedBack: TLabel;
    btnSave: TSpeedButton;
    btnDelete: TSpeedButton;
    Label2: TLabel;
    Bevel4: TBevel;
    Bevel5: TBevel;
    lblModRate: TLabel;
    Bevel6: TBevel;
    Label3: TLabel;
    sliderDryMix: TMMSlider;
    edDryMix: TMMNumberEdit;
    comboPreset: TComboBox;
    sliderWetMix: TMMSlider;
    edWetMix: TMMNumberEdit;
    sliderFeedBack: TMMSlider;
    edFeedBack: TMMNumberEdit;
    sliderDelay: TMMSlider;
    edDelay: TMMNumberEdit;
    sliderRate: TMMSlider;
    sliderDepth: TMMSlider;
    edRate: TMMFloatNumberEdit;
    edDepth: TMMFloatNumberEdit;
    procedure StartBtnClick(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MMHiTimer1Timer(Sender: TObject);
    procedure MMWaveInStart(Sender: TObject);
    procedure MMWaveInStop(Sender: TObject);
    procedure PcmOverflow(Sender: TObject);
    procedure VolumeMasterChange(Sender: TObject);
    procedure sliderChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure comboPresetChange(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure FlangerChange(Sender: TObject);
    procedure edExit(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    IniFile: TFileName;
  public
    procedure UpdateComboBox;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
   IniFile := ExtractFilePath(Application.ExeName)+'Flanger.ini';
   UpdateComboBox;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   MMHiTimer1.Enabled := False;
   
   { stop and close the device }
   MMWaveIn.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormShow(Sender: TObject);
begin
   { is the current device a Full-Duplex device ? }
   if not DeviceFullDuplex(MMWaveIn.DeviceID,MMWaveIn.PWaveFormat) then
   begin
      if (MMWaveIn.Mode = mStereo) then
          MessageDlg('You need a "Full-Duplex" device to run this demo'#10#13+
                     'Some older devices do not support Full-Duplex in stereo.', mtError, [mbOK], 0)
      else
          MessageDlg('You need a "Full-Duplex" device to run this demo', mtError, [mbOK], 0);

      StopBtn.Enabled := False;
      StartBtn.Enabled := False;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.StartBtnClick(Sender: TObject);
begin
   { open and start the device }
   MMWaveIn.Start;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.StopBtnClick(Sender: TObject);
begin
   { stop and close the device }
   MMWaveIn.Close;

   DSPLabel.Caption := '0 %';

   LEDOver.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.MMHiTimer1Timer(Sender: TObject);
begin
   DSPLabel.Caption := IntToStr(DSPMeter.Value)+ ' %';

   LEDOver.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.MMWaveInStart(Sender: TObject);
begin
   MMHiTimer1.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.MMWaveInStop(Sender: TObject);
begin
   MMHiTimer1.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.PcmOverflow(Sender: TObject);
begin
   LEDOver.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.VolumeMasterChange(Sender: TObject);
begin
   MasterVolume.Volume := VolumeMaster.Value;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.UpdateComboBox;
begin
   Flanger.ReadIniSections(IniFile,comboPreset.Items);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.comboPresetChange(Sender: TObject);
begin
   Flanger.ReadFromIniFile(IniFile,comboPreset.Items[comboPreset.ItemIndex]);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.sliderChange(Sender: TObject);
begin
   edDelay.Value    := SliderDelay.Position;
   edDryMix.Value   := SliderDryMix.Position;
   edWetMix.Value   := SliderWetMix.Position;
   edFeedBack.Value := SliderFeedBack.Position;
   edRate.Value     := SliderRate.Position/100;
   edDepth.Value    := SliderDepth.Position/100;

   Flanger.Delay    := SliderDelay.Position;
   Flanger.DryMix   := SliderDrymix.Position;
   Flanger.WetMix   := SliderWetmix.Position;
   Flanger.FeedBack := SliderFeedBack.Position;
   Flanger.Rate     := SliderRate.Position/100;
   Flanger.Depth    := SliderDepth.Position/100;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FlangerChange(Sender: TObject);
begin
   with Flanger do
   begin
      SliderDelay.Position    := Delay;
      edDelay.Value           := Delay;

      SliderDryMix.Position   := DryMix;
      edDryMix.Value          := DryMix;

      SliderWetMix.Position   := WetMix;
      edWetMix.Value          := WetMix;

      SliderFeedBack.Position := FeedBack;
      edFeedBack.Value        := FeedBack;

      SliderRate.Position     := Trunc(Rate*100);
      edRate.Value            := Rate;

      SliderDepth.Position    := Trunc(Depth*100);
      edDepth.Value           := Depth;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.edExit(Sender: TObject);
begin
   SliderDelay.Position    := edDelay.Value;
   SliderDryMix.Position   := edDryMix.Value;
   SliderWetMix.Position   := edWetMix.Value;
   SliderFeedBack.Position := edFeedBack.Value;
   SliderRate.Position     := Trunc(edRate.Value*100);
   SliderDepth.Position    := Trunc(edDepth.Value*100);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnSaveClick(Sender: TObject);
begin
   with comboPreset do
   begin
      if (Text <> '') then
      begin
         if Items.IndexOf(Text) >= 0 then
            if MessageDlg('Overwrite existing preset ?', mtInformation, mbOKCancel, 0) = mrCancel then exit;

         Flanger.SaveToIniFile(IniFile,Text);
         UpdateComboBox;
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnDeleteClick(Sender: TObject);
begin
   with comboPreset do
   begin
      if (Text <> '') then
      begin
         Flanger.DeleteSection(IniFile,Text);
         Text := '';
         UpdateComboBox;
      end;
   end;
end;

end.
